#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

static DWORD dwId[] = {p1, p2, p3, p4, p5, p6};
#define NB_PINGS (sizeof(dwId)/sizeof(DWORD))
static Obj3d Newping[NB_PINGS], *pSol;
#define POPULATION (20)
static float Matrix[16], Matrix2[16], Matrix3[16], PingMatrix[POPULATION][16], World[16];
static float Gouraud[16], Gouraud2[16];

static float VectX[POPULATION], VectZ[POPULATION];

void LInit_Newping()
{
	int Cpt1;
	float x,z;
	float fRandLen;
	DWORD dwAndleAngle;

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 2048);
	RotateYMatrix(Matrix, Matrix2, 2048);
	// now, "Matrix" is the way to make the ping faced to the camera

	// turn the pinguin
	for(Cpt1=0;Cpt1<NB_PINGS;Cpt1++)
	{
		// load
		LoadObject(&Newping[Cpt1], dwId[Cpt1]);
		ApplyMatrix(&Newping[Cpt1], Matrix);
		ComputeGouraud(&Newping[Cpt1]);		
	}
	// Compute matrices so the pings are facing the same point
	for(Cpt1=0;Cpt1<POPULATION;Cpt1++)
	{
		// Compute new pos
		fRandLen = 50.f*CosTable[(Cpt1*3456)&8191];
		//dwAndleAngle = 300.f*CosTable[(Cpt1*6543)&8191];
		x = (300.f+fRandLen)*CosTable[(Cpt1*8192/POPULATION)&8191];
		z = (300.f+fRandLen)*SinTable[(Cpt1*8192/POPULATION)&8191];
		VectX[Cpt1] = -CosTable[(Cpt1*8192/POPULATION)&8191];
		VectZ[Cpt1] = -SinTable[(Cpt1*8192/POPULATION)&8191];
		// create a matrix
		BeIdentityMatrix(Matrix);
		RotateYMatrix(PingMatrix[Cpt1], Matrix, -Cpt1*8192/POPULATION+2048);
		TranslateMatrix(PingMatrix[Cpt1], x, 0, z);
	}

	pSol = GenerateFloor(2, 2, 1024.f, 1024.f, 2048, 2048);
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 2048);
	TranslateMatrix(Matrix2, 0,35,0);
	ApplyMatrix(pSol, Matrix2);

	PrepareTextureFromArray(g_PicTunn3d, 256, 256, &g_TextureTunn3d);
}

void QInit_Newping()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
					//GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(0);
	grFogTable(g_FogPing);

	grConstantColorValue(0x808080);

	DownloadTexture(&g_TextureTunn3d);
	SelectTexture(g_TextureTunn3d);

	BeIdentityMatrix(Gouraud);
}

void Effect_Newping()
{
	int Cpt1;

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_ITERATED, FXFALSE);

	// world
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 2048);

	if (g_demostate.TickInEffect<6000)
	{
		TranslateMatrix(Matrix2, 0,0,450-g_demostate.TickInEffect/16);
	}
	else
	{
		TranslateMatrix(Matrix2, 0,0,450-6000/16);
	}

	if (g_demostate.TickInEffect>2048)
	if (g_demostate.TickInEffect<2048+4096)
	{
		RotateZMatrix(Matrix, Matrix2, (g_demostate.TickInEffect-2048)/2);
		RotateXMatrix(Matrix2, Matrix, -(g_demostate.TickInEffect-2048)/4);
	}
	else
	{
		RotateZMatrix(Matrix, Matrix2, (g_demostate.TickInEffect-2048)/2);
		RotateXMatrix(Matrix2, Matrix, -1024);
	}

	for(Cpt1=0;Cpt1<POPULATION;Cpt1++)
	{
		BeIdentityMatrix(Gouraud2);
		//RotateYMatrix(Matrix, PingMatrix[Cpt1], g_demostate.TickInEffect);
		//RotateYMatrix(Gouraud2, Gouraud, g_demostate.TickInEffect); // useless
		// object
		CopyMatrix(Matrix3, PingMatrix[Cpt1]);
		TranslateMatrix(Matrix3, VectX[Cpt1]*g_demostate.TickInEffect/64,
			0, VectZ[Cpt1]*g_demostate.TickInEffect/64);
		// combine world and object
		MulMatrix(Matrix, Matrix2, Matrix3);
		DrawWithMatrix(&Newping[(g_demostate.TickInEffect/128+Cpt1)%NB_PINGS], 
			Matrix, TRUE, Gouraud2, 0);
	}

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	BeIdentityMatrix(Matrix);
	MulMatrix(Matrix3, Matrix2, Matrix);
	DrawWithMatrix(pSol, Matrix3, TRUE, Gouraud2, 0);

}

void ByeBye_Newping()
{
	FreeTexture(&g_TextureTunn3d);
}